package com.sinosoftgz.starter.redis.properties;

import cn.hutool.core.util.StrUtil;
import com.sinosoftgz.starter.redis.constants.RedisConstants;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by roney on 2022/5/1 19:49
 * Redis 序列化和反序列化配置
 */

@ConfigurationProperties(prefix = RedisSerializerProperties.REDIS_SERIALIZER_PREFIX)
@Data
public class RedisSerializerProperties {

    public static final String REDIS_SERIALIZER_PREFIX = RedisConstants.REDIS_PREFIX + StrUtil.DOT + "serializer";

    /**
     * 是否开启redis 序列化配置
     * 默认开启
     */
    private boolean enabled = true;

    /**
     * redis序列化方式，默认使用Jackson2
     * 选项Jackson/FastJson/Kryo
     */
    private String type = "Jackson";

    /**
     * FastJson序列化以及反序列化 accept package 前缀
     */
    private String fastJsonAcceptPackagePrefix;

}
