/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.config;

import com.alibaba.fastjson.parser.ParserConfig;
import com.sinosoftgz.starter.redis.properties.RedisSerializerProperties;
import com.sinosoftgz.starter.redis.serializer.FastJsonRedisSerializer;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(name={"com.alibaba.fastjson.JSON"})
@ConditionalOnProperty(prefix="redis.serializer", name={"type"}, havingValue="FastJson", matchIfMissing=false)
@EnableConfigurationProperties(value={RedisSerializerProperties.class})
public class FastJsonConfiguration {
    private RedisSerializerProperties redisSerializerProperties;

    public FastJsonConfiguration(RedisSerializerProperties redisSerializerProperties) {
        this.redisSerializerProperties = redisSerializerProperties;
    }

    @Bean
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        FastJsonRedisSerializer<Object> fastJsonRedisSerializer = new FastJsonRedisSerializer<Object>(Object.class);
        CacheKeyPrefix keyPrefix = new CacheKeyPrefix(){

            public String compute(String cacheName) {
                return cacheName + ":" + ":";
            }
        };
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(3L)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(fastJsonRedisSerializer)).disableCachingNullValues();
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(config).build();
    }

    @Bean
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate redisTemplate = new StringRedisTemplate(factory);
        FastJsonRedisSerializer<Object> fastJsonRedisSerializer = new FastJsonRedisSerializer<Object>(Object.class);
        if (!StringUtils.hasLength((String)this.redisSerializerProperties.getFastJsonAcceptPackagePrefix())) {
            throw new RuntimeException("\u4f7f\u7528FastJson\u5e8f\u5217\u5316,\u8bf7\u914d\u7f6eaccept package \u524d\u7f00");
        }
        ParserConfig.getGlobalInstance().addAccept(this.redisSerializerProperties.getFastJsonAcceptPackagePrefix());
        redisTemplate.setValueSerializer(fastJsonRedisSerializer);
        redisTemplate.setHashValueSerializer(fastJsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

