/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.config;

import com.sinosoftgz.starter.redis.properties.RedisSerializerProperties;
import com.sinosoftgz.starter.redis.serializer.KryoRedisSerializer;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnClass(name={"com.esotericsoftware.kryo.Kryo"})
@ConditionalOnProperty(prefix="redis.serializer", name={"type"}, havingValue="Kryo", matchIfMissing=false)
@EnableConfigurationProperties(value={RedisSerializerProperties.class})
public class KryoConfiguration {
    private RedisSerializerProperties redisSerializerProperties;

    public KryoConfiguration(RedisSerializerProperties redisSerializerProperties) {
        this.redisSerializerProperties = redisSerializerProperties;
    }

    @Bean
    public CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        KryoRedisSerializer<Object> kryoRedisSerializer = new KryoRedisSerializer<Object>(Object.class);
        CacheKeyPrefix keyPrefix = new CacheKeyPrefix(){

            public String compute(String cacheName) {
                return cacheName + ":" + ":";
            }
        };
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(3L)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)redisSerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(kryoRedisSerializer)).disableCachingNullValues();
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(config).build();
    }

    @Bean
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate redisTemplate = new StringRedisTemplate(factory);
        KryoRedisSerializer<Object> kryoRedisSerializer = new KryoRedisSerializer<Object>(Object.class);
        redisTemplate.setValueSerializer(kryoRedisSerializer);
        redisTemplate.setHashValueSerializer(kryoRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

