/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.config;

import com.sinosoftgz.starter.redis.api.RedisToolController;
import com.sinosoftgz.starter.redis.config.FastJsonConfiguration;
import com.sinosoftgz.starter.redis.config.JacksonConfiguration;
import com.sinosoftgz.starter.redis.config.KryoConfiguration;
import com.sinosoftgz.starter.redis.properties.RedisLockProperties;
import com.sinosoftgz.starter.redis.utils.RedisLockUtils;
import com.sinosoftgz.starter.redis.utils.RedisUtils;
import java.lang.reflect.Method;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@EnableCaching
@Import(value={JacksonConfiguration.class, FastJsonConfiguration.class, KryoConfiguration.class, RedisToolController.class})
@EnableConfigurationProperties(value={RedisProperties.class, RedisLockProperties.class})
public class RedisConfiguration
extends CachingConfigurerSupport {
    @Bean
    public KeyGenerator wiselyKeyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName());
                sb.append(method.getName());
                for (Object obj : params) {
                    sb.append(":").append(String.valueOf(obj));
                }
                return sb.toString().replaceAll("\\.", ":");
            }
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="redis.lock", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public RedisLockUtils redisLockUtils(StringRedisTemplate stringRedisTemplate) {
        RedisLockUtils redisLockUtils = new RedisLockUtils(stringRedisTemplate);
        return redisLockUtils;
    }

    @Bean
    public RedisUtils redisUtils(RedisTemplate redisTemplate) {
        RedisUtils redisUtils = new RedisUtils();
        redisUtils.setRedisTemplate((RedisTemplate<String, Object>)redisTemplate);
        return redisUtils;
    }
}

