/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.utils;

import com.google.common.base.Preconditions;
import com.sinosoftgz.starter.redis.properties.RedisLockProperties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisLockUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisLockUtils.class);
    @Resource
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    RedisLockProperties redisLockProperties;

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public RedisLockUtils(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public boolean lock(String key, long lockTime) {
        Preconditions.checkArgument((lockTime > System.currentTimeMillis() ? 1 : 0) != 0, (Object)"\u52a0\u9501\u65f6\u957f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        return this.lock(key, String.valueOf(lockTime));
    }

    public boolean lock(String key) {
        return this.lock(key, "");
    }

    public void unlock(String key) {
        Preconditions.checkNotNull((Object)key, (Object)String.format("%s must be have value!", "key"));
        try {
            key = this.getLockKey(key);
            log.info("unlock key: {}", (Object)key);
            this.stringRedisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.error("redis \u89e3\u9501\u5f02\u5e38:", (Throwable)e);
        }
    }

    private boolean lock(String key, String value) {
        String oldValue;
        Preconditions.checkNotNull((Object)key, (Object)String.format("%s must be have value!", "key"));
        key = this.getLockKey(key);
        log.info("lock key: {}", (Object)key);
        if (StringUtils.isEmpty((Object)value)) {
            value = String.valueOf(System.currentTimeMillis() + this.redisLockProperties.getTimeout());
        }
        if (this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value).booleanValue()) {
            return true;
        }
        String currentValue = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        return !StringUtils.isEmpty((Object)currentValue) && Long.parseLong(currentValue) < System.currentTimeMillis() && !StringUtils.isEmpty((Object)(oldValue = (String)this.stringRedisTemplate.opsForValue().getAndSet((Object)key, (Object)value))) && oldValue.equals(currentValue);
    }

    private String getLockKey(String key) {
        return this.redisLockProperties.getPrefix() + key;
    }
}

