/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.redis.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean expire(String key, long time) {
        this.checkCacheKey(key);
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public long getExpire(String key) {
        this.checkCacheKey(key);
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public void delete(String ... key) {
        Preconditions.checkNotNull((Object)key);
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete(Arrays.asList(key));
            }
        }
    }

    public Object get(String key) {
        this.checkCacheKey(key);
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        this.checkCacheKey(key);
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        this.checkCacheKey(key);
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public long incr(String key, long delta) {
        this.checkCacheKey(key);
        Preconditions.checkArgument((delta > 0L ? 1 : 0) != 0, (Object)"\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        this.checkCacheKey(key);
        Preconditions.checkArgument((delta > 0L ? 1 : 0) != 0, (Object)"\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hashGet(String key, String item) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item, (Object)String.format("%s must be have value!", "item"));
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hashMapGet(String key) {
        this.checkCacheKey(key);
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hashMapSet(String key, Map<String, Object> map) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean hashMapSet(String key, Map<String, Object> map, long time) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean hashSet(String key, String item, Object value) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item, (Object)String.format("%s must be have value!", "item"));
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean hashSet(String key, String item, Object value, long time) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item, (Object)String.format("%s must be have value!", "item"));
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public void hashDelete(String key, Object ... item) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item);
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hashHasKey(String key, String item) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item, (Object)String.format("%s must be have value!", "item"));
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public long hashIncr(String key, String item, long delta) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item, (Object)String.format("%s must be have value!", "item"));
        Preconditions.checkArgument((delta > 0L ? 1 : 0) != 0, (Object)"\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, delta);
    }

    public long hashDecr(String key, String item, long delta) {
        this.checkCacheKey(key);
        Preconditions.checkNotNull((Object)item, (Object)String.format("%s must be have value!", "item"));
        Preconditions.checkArgument((delta > 0L ? 1 : 0) != 0, (Object)"\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -delta);
    }

    public Set<Object> setGet(String key) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public boolean setHasKey(String key, Object value) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public long setSet(String key, Object ... values) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return 0L;
        }
    }

    public long setSetTime(String key, long time, Object ... values) {
        this.checkCacheKey(key);
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return 0L;
        }
    }

    public long getSetSize(String key) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        this.checkCacheKey(key);
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return 0L;
        }
    }

    public List<Object> listGet(String key, long start, long end) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public long listGetSize(String key) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return 0L;
        }
    }

    public Object listGetIndex(String key, long index) {
        this.checkCacheKey(key);
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public boolean listSet(String key, Object value) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean listSet(String key, Object value, long time) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean listSet(String key, List<Object> value) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean listSet(String key, List<Object> value, long time) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public boolean listUpdateByIndex(String key, long index, Object value) {
        this.checkCacheKey(key);
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    public long listRemove(String key, long count, Object value) {
        this.checkCacheKey(key);
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)e);
            return 0L;
        }
    }

    private void checkCacheKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)String.format("%s must be have value!", "key"));
    }
}

