package com.sinosoftgz.starter.captcha.core.api;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;

/**
 * 验证码统一标准接口
 *
 * @author: Roney
 * @createTime: 2022/06/14 17:43
 * @description: 验证码统一标准接口
 * 各个业务方实现接口，默认是http协议，后续可以增加RPC等协议，由各个业务系统技术栈决定
 */
public interface CaptchaApi {


    /**
     * 获取验证码
     *
     * @param getCaptchaReq
     * @return
     */
    public BaseResponse<GetCaptchaResp> get(GetCaptchaReq getCaptchaReq);

    /**
     * 校验验证码
     *
     * @param checkCaptchaReq
     * @return
     */
    public BaseResponse<CheckCaptchaResp> check(CheckCaptchaReq checkCaptchaReq);


}
