package com.sinosoftgz.starter.captcha.core.api.exception;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.captcha.core.enums.CaptchaRespCode;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaIncorrectException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaNotFoundException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaTimeoutException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 验证码异常处理类
 *
 * @author: Roney
 * @createTime: 2022/06/13 20:44
 * @description: 验证码异常处理类
 */
@RestControllerAdvice
@Slf4j
public class CaptchaExceptionHandler {

    @ExceptionHandler(value = CaptchaException.class)
    public BaseResponse CaptchaExceptionHandler(CaptchaException captchaException) {
        log.error("验证码异常", captchaException);
        if (captchaException instanceof CaptchaIncorrectException) {
            return BaseResponse.error(CaptchaRespCode.INCORRECT.getResultCode(), CaptchaRespCode.INCORRECT.getResultMsg());
        } else if (captchaException instanceof CaptchaNotFoundException) {
            return BaseResponse.error(CaptchaRespCode.NOT_FOUND.getResultCode(), CaptchaRespCode.NOT_FOUND.getResultMsg());
        } else if (captchaException instanceof CaptchaTimeoutException) {
            return BaseResponse.error(CaptchaRespCode.EXPIRE.getResultCode(), CaptchaRespCode.EXPIRE.getResultMsg());
        } else {
            return BaseResponse.error(CaptchaRespCode.RENDER_FAIL.getResultCode(), CaptchaRespCode.RENDER_FAIL.getResultMsg());
        }

    }
}
