package com.sinosoftgz.starter.captcha.core.api.impl;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.captcha.core.api.CaptchaApi;
import com.sinosoftgz.starter.captcha.core.biz.CaptchaBiz;
import com.sinosoftgz.starter.captcha.core.constant.CaptchaConstants;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * 验证码 http 协议接口实现
 *
 * @author: Roney
 * @createTime: 2022/06/14 18:04
 * @description: 验证码 http 协议接口实现
 */
@RestController
@RequestMapping(CaptchaConstants.APP_BASE_CONTEXT)
@Slf4j
public class CaptchaApiController implements CaptchaApi {

    @Resource
    CaptchaBiz captchaBiz;

    /**
     * 获取验证码
     *
     * @param getCaptchaReq
     * @return
     */
    @RequestMapping(value = "/get", method = {RequestMethod.GET, RequestMethod.POST})
    @Override
    public BaseResponse<GetCaptchaResp> get(GetCaptchaReq getCaptchaReq) {
        return captchaBiz.get(getCaptchaReq);
    }

    /**
     * 校验验证码
     *
     * @param checkCaptchaReq
     * @return
     */
    @PostMapping(value = "/check")
    @Override
    public BaseResponse<CheckCaptchaResp> check(@Valid @RequestBody CheckCaptchaReq checkCaptchaReq) {
        return captchaBiz.check(checkCaptchaReq);
    }
}
