package com.sinosoftgz.starter.captcha.core.biz.impl;

import com.sinosoftgz.global.common.constants.CommonConstants;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.captcha.core.biz.CaptchaBiz;
import com.sinosoftgz.starter.captcha.core.constant.CaptchaConstants;
import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.enums.CaptchaType;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaNotFoundException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaRenderException;
import com.sinosoftgz.starter.captcha.core.handler.AbstractCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.handler.CaptchaHandlerContext;
import com.sinosoftgz.starter.captcha.core.properties.CaptchaProperties;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.sinosoftgz.starter.captcha.storage.core.api.CaptchaStorageApi;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 验证码统一标准接口业务逻辑实现
 *
 * @author: Roney
 * @createTime: 2022/06/14 18:09
 * @description: 验证码统一标准接口业务逻辑实现
 */
@Component
@Slf4j
public class CaptchaBizImpl implements CaptchaBiz {

    @Resource
    CaptchaHandlerContext captchaHandlerContext;

    @Resource
    CaptchaProperties captchaProperties;

    /**
     * 不需要调接口，直接调用biz即可
     */
    @Resource
    @Qualifier("captchaStorageBizImpl")
    public CaptchaStorageApi captchaStorageApi;

    @Override
    public BaseResponse<GetCaptchaResp> get(GetCaptchaReq getCaptchaReq) {

        Assert.notNull(getCaptchaReq, CommonConstants.MessageString.ASSERT_NOT_NULL_OBJECT_MESSAGE);
        Assert.notNull(getCaptchaReq.getType(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "type"));
        Assert.isTrue(CaptchaType.captchaTypeMap.containsKey(getCaptchaReq.getType()), "验证码类型不合法");
        String businessCaptchaTypeStr = captchaProperties.getCategoryType() + getCaptchaReq.getType();
        Assert.isTrue(BusinessCaptchaType.businessCaptchaTypeMap.containsKey(businessCaptchaTypeStr), "验证码分类以及验证码类型不合法");
        BusinessCaptchaType businessCaptchaType = BusinessCaptchaType.businessCaptchaTypeMap.get(businessCaptchaTypeStr);
        Assert.notNull(businessCaptchaType, CommonConstants.MessageString.ASSERT_NOT_NULL_OBJECT_MESSAGE);
        AbstractCaptchaHandler abstractCaptchaHandler = (AbstractCaptchaHandler) captchaHandlerContext.getInstance(businessCaptchaType);
        try {
            GetCaptchaResp getCaptchaResp = abstractCaptchaHandler.get(getCaptchaReq);
            /**
             * 根据验证码Id存储验证码类型，方便校验使用
             */
            captchaStorageApi.set(CaptchaConstants.CachePrefix.CAPTCHA_CACHE_BUSINESS_CAPTCHA_TYPE_CACHE_KEY + getCaptchaResp.getCaptchaId(), businessCaptchaTypeStr);
            return BaseResponse.ok(getCaptchaResp);
        } catch (Exception e) {
            throw new CaptchaRenderException();
        }
    }

    @Override
    public BaseResponse<CheckCaptchaResp> check(CheckCaptchaReq checkCaptchaReq) {

        Assert.notNull(checkCaptchaReq, CommonConstants.MessageString.ASSERT_NOT_NULL_OBJECT_MESSAGE);
        Assert.notNull(checkCaptchaReq.getCaptchaId(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "captchaId"));
        Assert.notNull(checkCaptchaReq.getCaptchaCode(), String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "captchaCode"));
        Assert.isTrue(captchaStorageApi.exists(CaptchaConstants.CachePrefix.CAPTCHA_CACHE_BUSINESS_CAPTCHA_TYPE_CACHE_KEY + checkCaptchaReq.getCaptchaId()), "验证码分类以及验证码类型不合法");
        BusinessCaptchaType businessCaptchaType = BusinessCaptchaType.businessCaptchaTypeMap.get(captchaStorageApi.get(CaptchaConstants.CachePrefix.CAPTCHA_CACHE_BUSINESS_CAPTCHA_TYPE_CACHE_KEY + checkCaptchaReq.getCaptchaId()));
        Assert.notNull(businessCaptchaType, CommonConstants.MessageString.ASSERT_NOT_NULL_OBJECT_MESSAGE);
        AbstractCaptchaHandler abstractCaptchaHandler = (AbstractCaptchaHandler) captchaHandlerContext.getInstance(businessCaptchaType);
        CheckCaptchaResp checkCaptchaResp = abstractCaptchaHandler.check(checkCaptchaReq);
        return BaseResponse.ok(checkCaptchaResp);


    }

    @Override
    public BaseResponse<CheckCaptchaResp> verification(CheckCaptchaReq checkCaptchaReq) {
        return null;
    }
}
