package com.sinosoftgz.starter.captcha.core.config;

import com.sinosoftgz.starter.captcha.core.api.impl.CaptchaApiController;
import com.sinosoftgz.starter.captcha.core.properties.CaptchaProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * CaptchaConfiguration
 *
 * @author: Roney
 * @createTime: 2022/06/12 21:15
 * @description: CaptchaConfiguration
 */

@Configuration
@Import({
        CaptchaApiController.class
})
@ComponentScan(basePackages = {"com.sinosoftgz.starter.captcha.core.**", "com.sinosoftgz.starter.spring.utils.**"})
@EnableConfigurationProperties(CaptchaProperties.class)
@ConditionalOnProperty(prefix = CaptchaProperties.CAPTCHA_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class CaptchaConfiguration {
    private CaptchaProperties captchaProperties;

    public CaptchaConfiguration(final CaptchaProperties captchaProperties) {
        this.captchaProperties = captchaProperties;
    }
}
