package com.sinosoftgz.starter.captcha.core.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 验证码分类类型
 *
 * @author: Roney
 * @createTime: 2022/06/14 20:26
 * @description: 验证码分类类型
 */
public enum CaptchaCategoryType {
    KAPTCHA("KAPTCHA", "谷歌验证码"),
    EASY_CAPTCHA("EASY_CAPTCHA", "easy captcha 验证码"),
    SLIDER("SLIDER", "滑块验证码"),
    ;


    public static Map<String, CaptchaCategoryType> captchaCategoryTypeMap = Maps.newConcurrentMap();


    static {
        captchaCategoryTypeMap.put(KAPTCHA.getCategoryType(), KAPTCHA);
        captchaCategoryTypeMap.put(EASY_CAPTCHA.getCategoryType(), EASY_CAPTCHA);
        captchaCategoryTypeMap.put(SLIDER.getCategoryType(), SLIDER);
    }

    /**
     * 分类类型
     */
    private String categoryType;
    /**
     * 描述
     */
    private String remark;

    CaptchaCategoryType(String categoryType, String remark) {
        this.categoryType = categoryType;
        this.remark = remark;
    }

    public String getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
