package com.sinosoftgz.starter.captcha.core.enums;

/**
 * 验证码返回code
 *
 * @author: Roney
 * @createTime: 2022/06/13 20:42
 * @description: 验证码返回code
 */
public enum CaptchaRespCode {
    /**
     * 获取验证码成功 C *****
     */
    SUCCESS("C00000", "获取验证码成功"),
    CHECK_SUCCESS("C00001", "校验成功"),
    /**
     * 验证码异常
     */
    INCORRECT("C10000", "验证码不正确"),
    NOT_FOUND("C10001", "验证码未找到"),
    EXPIRE("C10002", "验证码过期"),
    RENDER_FAIL("C10003", "验证码渲染失败"),
    ;

    CaptchaRespCode(String resultCode, String resultMsg) {
        this.resultCode = resultCode;
        this.resultMsg = resultMsg;
    }

    /**
     * 错误码
     */
    private String resultCode;

    /**
     * 错误描述
     */
    private String resultMsg;

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMsg() {
        return resultMsg;
    }

    public void setResultMsg(String resultMsg) {
        this.resultMsg = resultMsg;
    }
}
