package com.sinosoftgz.starter.captcha.core.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 验证码类型
 *
 * @author: Roney
 * @createTime: 2022/06/15 10:27
 * @description: 验证码类型
 */
public enum CaptchaType {
    /**
     * 谷歌验证码
     */
    CHAR("CHAR", "字符串"),
    MATH_EXPRESSION("MATH", "运算符表达式"),
    /**
     * easy captcha
     */
    DEFAULT("DEFAULT", "数字和字母混合"),
    ONLY_NUMBER("ONLY_NUMBER", "纯数字"),
    ONLY_CHAR("ONLY_CHAR", "纯字母"),
    ONLY_UPPER("ONLY_UPPER", "纯大写字母"),
    NUM_AND_UPPER("NUM_AND_UPPER", "数字和大写字母"),
    GIF_DEFAULT("GIF_DEFAULT", "GIF数字和字母混合"),
    GIF_ONLY_NUMBER("GIF_ONLY_NUMBER", "GIF纯数字"),
    GIF_ONLY_CHAR("GIF_ONLY_CHAR", "GIF纯字母"),
    GIF_ONLY_UPPER("GIF_ONLY_UPPER", "GIF纯大写字母"),
    GIF_NUM_AND_UPPER("GIF_NUM_AND_UPPER", "GIF数字和大写字母"),
    CHINESE("CHINESE", "中文"),
    GIF_CHINESE("GIF_CHINESE", "GIF中文"),
    ARITHMETIC("ARITHMETIC", "算术类型"),

    /**
     * 滑块验证码
     */
    BLOCK_PUZZLE("BLOCK_PUZZLE", "滑块拼图"),
    CLICK_WORD("CLICK_WORD", "文字点选"),
    ;


    public static Map<String, CaptchaType> captchaTypeMap = Maps.newConcurrentMap();


    static {
        /**
         * 谷歌验证码
         */
        captchaTypeMap.put(CHAR.getType(), CHAR);
        captchaTypeMap.put(MATH_EXPRESSION.getType(), MATH_EXPRESSION);

        /**
         * easy captcha
         */
        captchaTypeMap.put(DEFAULT.getType(), DEFAULT);
        captchaTypeMap.put(ONLY_NUMBER.getType(), ONLY_NUMBER);
        captchaTypeMap.put(ONLY_CHAR.getType(), ONLY_CHAR);
        captchaTypeMap.put(ONLY_UPPER.getType(), ONLY_UPPER);
        captchaTypeMap.put(NUM_AND_UPPER.getType(), NUM_AND_UPPER);
        captchaTypeMap.put(GIF_DEFAULT.getType(), GIF_DEFAULT);
        captchaTypeMap.put(GIF_ONLY_NUMBER.getType(), GIF_ONLY_NUMBER);
        captchaTypeMap.put(GIF_ONLY_CHAR.getType(), GIF_ONLY_CHAR);
        captchaTypeMap.put(GIF_ONLY_UPPER.getType(), GIF_ONLY_UPPER);
        captchaTypeMap.put(GIF_NUM_AND_UPPER.getType(), GIF_NUM_AND_UPPER);
        captchaTypeMap.put(CHINESE.getType(), CHINESE);
        captchaTypeMap.put(GIF_CHINESE.getType(), GIF_CHINESE);
        captchaTypeMap.put(ARITHMETIC.getType(), ARITHMETIC);

        /**
         * 滑块验证码
         */
        captchaTypeMap.put(BLOCK_PUZZLE.getType(), BLOCK_PUZZLE);
        captchaTypeMap.put(CLICK_WORD.getType(), CLICK_WORD);
    }

    /**
     * 类型
     */
    private String type;
    /**
     * 描述
     */
    private String remark;

    CaptchaType(String type, String remark) {
        this.type = type;
        this.remark = remark;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
