package com.sinosoftgz.starter.captcha.core.handler;

import cn.hutool.core.util.IdUtil;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.sinosoftgz.starter.captcha.storage.core.api.CaptchaStorageApi;
import com.sinosoftgz.starter.spring.utils.handler.AbstractHandler;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.Resource;

/**
 * AbstractCaptchaHandler
 *
 * @author: Roney
 * @createTime: 2022/06/17 18:20
 * @description: AbstractCaptchaHandler
 */
public abstract class AbstractCaptchaHandler extends AbstractHandler implements CaptchaHandler {

    /**
     * 不需要调接口，直接调用biz即可
     */
    @Resource
    @Qualifier("captchaStorageBizImpl")
    public CaptchaStorageApi captchaStorageApi;

    /**
     * 获取验证码
     *
     * @param getCaptchaReq 获取验证码请求参数
     * @return
     */
    @Override
    public abstract GetCaptchaResp get(GetCaptchaReq getCaptchaReq);

    /**
     * 校验验证码
     *
     * @param checkCaptchaReq
     * @return
     */
    @Override
    public abstract CheckCaptchaResp check(CheckCaptchaReq checkCaptchaReq);

    /**
     * 生成UUID
     *
     * @return
     */
    public String getUuid() {
        //生成的是不带-的字符串，类似于：b17f24ff026d40949c85a24f4f375d42
        String simpleUUID = IdUtil.simpleUUID();
        return simpleUUID;
    }


}
