package com.sinosoftgz.starter.captcha.core.handler;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.spring.utils.bean.BeansTools;
import com.sinosoftgz.starter.spring.utils.handler.AbstractHandler;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * CaptchaHandlerContext
 *
 * @author: Roney
 * @createTime: 2022/06/17 18:05
 * @description: CaptchaHandlerContext
 */
public class CaptchaHandlerContext {

    private Map<BusinessCaptchaType, Class> handlerMap;

    public CaptchaHandlerContext(Map<BusinessCaptchaType, Class> handlerMap) {
        this.handlerMap = handlerMap;
    }

    public AbstractHandler getInstance(BusinessCaptchaType type) {
        Class clazz = handlerMap.get(type);
        if (clazz == null) {
            throw new IllegalArgumentException("not found handler for type: " + type);
        }
        String beanName = StringUtils.uncapitalize(clazz.getSimpleName());
        return (AbstractHandler) BeansTools.getBean(beanName, clazz);
    }
}
