package com.sinosoftgz.starter.captcha.core.handler;

import com.google.common.collect.Maps;
import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.spring.utils.content.ClassResourceLoaderAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * CaptchaHandlerProcessor
 *
 * @author: Roney
 * @createTime: 2022/06/17 18:10
 * @description: CaptchaHandlerProcessor
 */
@Component
public class CaptchaHandlerProcessor implements BeanFactoryPostProcessor {
    /**
     * 指定扫描处理器的包，不做配置化，减少复杂度，只认这个包下的实现类
     */
    private static final String HANDLER_PACKAGE = "com.sinosoftgz.starter.captcha.core.handler";

    /**
     * 扫描@HandlerType，初始化HandlerContext，将其注册到spring容器
     *
     * @param beanFactory bean工厂
     * @see CaptchaHandlerType
     * @see CaptchaHandlerContext
     */
    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map<BusinessCaptchaType, Class> handlerMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan(HANDLER_PACKAGE, CaptchaHandlerType.class).forEach(clazz -> {
            BusinessCaptchaType type = clazz.getAnnotation(CaptchaHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        CaptchaHandlerContext context = new CaptchaHandlerContext(handlerMap);
        beanFactory.registerSingleton(CaptchaHandlerContext.class.getName(), context);
    }
}
