package com.sinosoftgz.starter.captcha.core.handler.biz;

import cn.hutool.core.util.IdUtil;
import com.sinosoftgz.starter.captcha.core.constant.CaptchaConstants;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaIncorrectException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaNotFoundException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaTimeoutException;
import com.sinosoftgz.starter.captcha.core.handler.AbstractCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * 验证码默认实现
 *
 * @author: Roney
 * @createTime: 2022/06/17 18:23
 * @description: 验证码默认实现
 */
@Component
@Slf4j
public abstract class DefaultCaptchaHandler extends AbstractCaptchaHandler {

    /**
     * 获取验证码 不实现由继承类实现
     *
     * @param getCaptchaReq 获取验证码请求参数
     * @return
     */
    @Override
    public abstract GetCaptchaResp get(GetCaptchaReq getCaptchaReq);

    @Override
    public CheckCaptchaResp check(CheckCaptchaReq checkCaptchaReq) {
        if (!Objects.isNull(checkCaptchaReq) && StringUtils.hasLength(checkCaptchaReq.getCaptchaId()) && StringUtils.hasLength(checkCaptchaReq.getCaptchaCode())) {
            String captchaId = checkCaptchaReq.getCaptchaId();
            if (captchaStorageApi.exists(captchaId)) {
                String captchaCode = checkCaptchaReq.getCaptchaCode();
                String cacheCaptchaCode = captchaStorageApi.get(captchaId);
                if (captchaCode.equalsIgnoreCase(cacheCaptchaCode)) {
                    /**
                     * 校验通过后，需要删除数据
                     */
                    captchaStorageApi.delete(captchaId);
                    /**
                     * 是否需要二次校验，如果需要，重新生成新的key，value保持不变，进行缓存
                     */
                    if (checkCaptchaReq.isCheckAgain()) {

                        String newCaptchaId = getUuid();
                        /**
                         * 二次校验需要拿到验证码分类和验证码类型
                         */
                        Assert.isTrue(captchaStorageApi.exists(CaptchaConstants.CachePrefix.CAPTCHA_CACHE_BUSINESS_CAPTCHA_TYPE_CACHE_KEY + checkCaptchaReq.getCaptchaId()), "验证码分类以及验证码类型不合法");
                        /**
                         * 根据验证码Id存储验证码类型，方便校验使用
                         */
                        captchaStorageApi.set(CaptchaConstants.CachePrefix.CAPTCHA_CACHE_BUSINESS_CAPTCHA_TYPE_CACHE_KEY + newCaptchaId, captchaStorageApi.get(CaptchaConstants.CachePrefix.CAPTCHA_CACHE_BUSINESS_CAPTCHA_TYPE_CACHE_KEY + checkCaptchaReq.getCaptchaId()));
                        captchaStorageApi.set(newCaptchaId, cacheCaptchaCode);
                        return new CheckCaptchaResp(newCaptchaId, true);
                    }
                    return new CheckCaptchaResp(captchaId, true);
                } else {
                    throw new CaptchaIncorrectException();
                }
            } else {
                throw new CaptchaTimeoutException();
            }
        } else {
            throw new CaptchaNotFoundException();
        }
    }
}
