package com.sinosoftgz.starter.captcha.core.properties;

import com.sinosoftgz.starter.captcha.core.enums.CaptchaCategoryType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * CaptchaProperties
 *
 * @author: Roney
 * @createTime: 2022/06/14 20:54
 * @description: CaptchaProperties
 */
@ConfigurationProperties(prefix = CaptchaProperties.CAPTCHA_PREFIX)
@Data
public class CaptchaProperties {

    public static final String CAPTCHA_PREFIX = "captcha";

    /**
     * 验证码分类类型
     * 默认是谷歌验证码
     */
    private String categoryType = CaptchaCategoryType.KAPTCHA.getCategoryType();


}
