package com.sinosoftgz.starter.captcha.core.request;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 校验验证码请求参数
 *
 * @author: Roney
 * @createTime: 2022/06/12 21:29
 * @description: 校验验证码请求参数
 */
@Data
public class CheckCaptchaReq implements Serializable {

    /**
     * 验证码id
     */
    @NotNull
    private String captchaId;

    /**
     * 验证码值
     */
    @NotNull
    private String captchaCode;

    /**
     * 是否需要二次校验，默认不做二次校验
     * 使用场景如下：现在大部分的网站，用户输入完成验证码后，就会校验验证码是否正确，在登录的时候，还会再次校验验证码是否正确
     */
    @NotNull
    private boolean checkAgain = false;

    /**
     * 校验验证码扩展信息请求参数
     */
    private CheckCaptchaExtReq checkCaptchaExtReq;

    public CheckCaptchaReq(String captchaId, String captchaCode) {
        this.captchaId = captchaId;
        this.captchaCode = captchaCode;
    }
}
