package com.sinosoftgz.starter.captcha.core.request;

import com.sinosoftgz.starter.captcha.core.enums.CaptchaType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 获取验证码请求参数
 *
 * @author: Roney
 * @createTime: 2022/06/12 21:28
 * @description: 获取验证码请求参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GetCaptchaReq implements Serializable {

    /**
     * 验证码类型
     * 默认为谷歌的字符串，此参数可以前端直接传，后端只做校验即可
     */
    @NotNull(message = "验证码类型不能为空")
    private String type = CaptchaType.CHAR.getType();

    /**
     * 宽度 默认130
     */
    private Integer width = 130;
    /**
     * 高度 默认48
     */
    private Integer height = 48;
    /**
     * 长度 默认5
     */
    private Integer length = 5;

    /**
     * 获取验证码请求参数扩展信息
     */
    private GetCaptchaExtReq getCaptchaExtReq;
}
