package com.sinosoftgz.starter.captcha.core.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 校验验证码返回参数
 *
 * @author: Roney
 * @createTime: 2022/06/14 17:51
 * @description: 校验验证码返回参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CheckCaptchaResp implements Serializable {
    /**
     * 验证码id
     */
    @NotNull
    private String captchaId;

    /**
     * 是否校验成功
     */
    @NotNull
    private boolean checkFlag;

    /**
     * 校验验证码返回对象扩展信息
     */
    private CheckCaptchaExtResp checkCaptchaExtResp;


    public CheckCaptchaResp(String captchaId, boolean checkFlag) {
        this.captchaId = captchaId;
        this.checkFlag = checkFlag;
    }
}
