package com.sinosoftgz.starter.captcha.core.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 获取验证码返回对象
 *
 * @author: Roney
 * @createTime: 2022/06/14 17:50
 * @description: 获取验证码返回对象
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GetCaptchaResp implements Serializable {

    /**
     * 验证码id
     */
    private String captchaId;

    /**
     * 原生图片base64
     */
    private String originalImageBase64;

    /**
     * base64的头部data:image/png;base64
     */
    private String imageBase64;

    /**
     * 获取验证码返回对象扩展信息
     */
    private GetCaptchaExtResp getCaptchaExtResp;


    public GetCaptchaResp(String captchaId, String originalImageBase64, String imageBase64) {
        this.captchaId = captchaId;
        this.originalImageBase64 = originalImageBase64;
        this.imageBase64 = imageBase64;
    }
}
