/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.api.exception;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.captcha.core.enums.CaptchaRespCode;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaIncorrectException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaNotFoundException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class CaptchaExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CaptchaExceptionHandler.class);

    @ExceptionHandler(value={CaptchaException.class})
    public BaseResponse CaptchaExceptionHandler(CaptchaException captchaException) {
        log.error("\u9a8c\u8bc1\u7801\u5f02\u5e38", (Throwable)captchaException);
        if (captchaException instanceof CaptchaIncorrectException) {
            return BaseResponse.error((String)CaptchaRespCode.INCORRECT.getResultCode(), (String)CaptchaRespCode.INCORRECT.getResultMsg());
        }
        if (captchaException instanceof CaptchaNotFoundException) {
            return BaseResponse.error((String)CaptchaRespCode.NOT_FOUND.getResultCode(), (String)CaptchaRespCode.NOT_FOUND.getResultMsg());
        }
        if (captchaException instanceof CaptchaTimeoutException) {
            return BaseResponse.error((String)CaptchaRespCode.EXPIRE.getResultCode(), (String)CaptchaRespCode.EXPIRE.getResultMsg());
        }
        return BaseResponse.error((String)CaptchaRespCode.RENDER_FAIL.getResultCode(), (String)CaptchaRespCode.RENDER_FAIL.getResultMsg());
    }
}

