/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.biz.impl;

import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.captcha.core.biz.CaptchaBiz;
import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.enums.CaptchaType;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaRenderException;
import com.sinosoftgz.starter.captcha.core.handler.AbstractCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.handler.CaptchaHandlerContext;
import com.sinosoftgz.starter.captcha.core.properties.CaptchaProperties;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.sinosoftgz.starter.captcha.storage.core.api.CaptchaStorageApi;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class CaptchaBizImpl
implements CaptchaBiz {
    private static final Logger log = LoggerFactory.getLogger(CaptchaBizImpl.class);
    @Resource
    CaptchaHandlerContext captchaHandlerContext;
    @Resource
    CaptchaProperties captchaProperties;
    @Resource
    @Qualifier(value="captchaStorageBizImpl")
    public CaptchaStorageApi captchaStorageApi;

    @Override
    public BaseResponse<GetCaptchaResp> get(GetCaptchaReq getCaptchaReq) {
        Assert.notNull((Object)getCaptchaReq, (String)"Object must be have value!");
        Assert.notNull((Object)getCaptchaReq.getType(), (String)String.format("%s must be have value!", "type"));
        Assert.isTrue((boolean)CaptchaType.captchaTypeMap.containsKey(getCaptchaReq.getType()), (String)"\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0d\u5408\u6cd5");
        String businessCaptchaTypeStr = this.captchaProperties.getCategoryType() + getCaptchaReq.getType();
        Assert.isTrue((boolean)BusinessCaptchaType.businessCaptchaTypeMap.containsKey(businessCaptchaTypeStr), (String)"\u9a8c\u8bc1\u7801\u5206\u7c7b\u4ee5\u53ca\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0d\u5408\u6cd5");
        BusinessCaptchaType businessCaptchaType = BusinessCaptchaType.businessCaptchaTypeMap.get(businessCaptchaTypeStr);
        Assert.notNull((Object)((Object)businessCaptchaType), (String)"Object must be have value!");
        AbstractCaptchaHandler abstractCaptchaHandler = (AbstractCaptchaHandler)this.captchaHandlerContext.getInstance(businessCaptchaType);
        try {
            GetCaptchaResp getCaptchaResp = abstractCaptchaHandler.get(getCaptchaReq);
            this.captchaStorageApi.set("BUSINESS:CAPTCHA:TYPE:" + getCaptchaResp.getCaptchaId(), businessCaptchaTypeStr);
            return BaseResponse.ok((Object)getCaptchaResp);
        }
        catch (Exception e) {
            throw new CaptchaRenderException();
        }
    }

    @Override
    public BaseResponse<CheckCaptchaResp> check(CheckCaptchaReq checkCaptchaReq) {
        Assert.notNull((Object)checkCaptchaReq, (String)"Object must be have value!");
        Assert.notNull((Object)checkCaptchaReq.getCaptchaId(), (String)String.format("%s must be have value!", "captchaId"));
        Assert.notNull((Object)checkCaptchaReq.getCaptchaCode(), (String)String.format("%s must be have value!", "captchaCode"));
        Assert.isTrue((boolean)this.captchaStorageApi.exists("BUSINESS:CAPTCHA:TYPE:" + checkCaptchaReq.getCaptchaId()), (String)"\u9a8c\u8bc1\u7801\u5206\u7c7b\u4ee5\u53ca\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0d\u5408\u6cd5");
        BusinessCaptchaType businessCaptchaType = BusinessCaptchaType.businessCaptchaTypeMap.get(this.captchaStorageApi.get("BUSINESS:CAPTCHA:TYPE:" + checkCaptchaReq.getCaptchaId()));
        Assert.notNull((Object)((Object)businessCaptchaType), (String)"Object must be have value!");
        AbstractCaptchaHandler abstractCaptchaHandler = (AbstractCaptchaHandler)this.captchaHandlerContext.getInstance(businessCaptchaType);
        CheckCaptchaResp checkCaptchaResp = abstractCaptchaHandler.check(checkCaptchaReq);
        return BaseResponse.ok((Object)checkCaptchaResp);
    }

    @Override
    public BaseResponse<CheckCaptchaResp> verification(CheckCaptchaReq checkCaptchaReq) {
        return null;
    }
}

