/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.handler;

import com.google.common.collect.Maps;
import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.CaptchaHandlerContext;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.spring.utils.content.ClassResourceLoaderAware;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class CaptchaHandlerProcessor
implements BeanFactoryPostProcessor {
    private static final String HANDLER_PACKAGE = "com.sinosoftgz.starter.captcha.core.handler";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConcurrentMap handlerMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan((String)HANDLER_PACKAGE, (Class[])new Class[]{CaptchaHandlerType.class}).forEach(clazz -> {
            BusinessCaptchaType type = clazz.getAnnotation(CaptchaHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        CaptchaHandlerContext context = new CaptchaHandlerContext(handlerMap);
        beanFactory.registerSingleton(CaptchaHandlerContext.class.getName(), (Object)context);
    }
}

