/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.exception.CaptchaIncorrectException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaNotFoundException;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaTimeoutException;
import com.sinosoftgz.starter.captcha.core.handler.AbstractCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.request.CheckCaptchaReq;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.CheckCaptchaResp;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public abstract class DefaultCaptchaHandler
extends AbstractCaptchaHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultCaptchaHandler.class);

    @Override
    public abstract GetCaptchaResp get(GetCaptchaReq var1);

    @Override
    public CheckCaptchaResp check(CheckCaptchaReq checkCaptchaReq) {
        if (!Objects.isNull(checkCaptchaReq) && StringUtils.hasLength((String)checkCaptchaReq.getCaptchaId()) && StringUtils.hasLength((String)checkCaptchaReq.getCaptchaCode())) {
            String captchaId = checkCaptchaReq.getCaptchaId();
            if (this.captchaStorageApi.exists(captchaId)) {
                String cacheCaptchaCode;
                String captchaCode = checkCaptchaReq.getCaptchaCode();
                if (captchaCode.equalsIgnoreCase(cacheCaptchaCode = this.captchaStorageApi.get(captchaId))) {
                    this.captchaStorageApi.delete(captchaId);
                    if (checkCaptchaReq.isCheckAgain()) {
                        String newCaptchaId = this.getUuid();
                        Assert.isTrue((boolean)this.captchaStorageApi.exists("BUSINESS:CAPTCHA:TYPE:" + checkCaptchaReq.getCaptchaId()), (String)"\u9a8c\u8bc1\u7801\u5206\u7c7b\u4ee5\u53ca\u9a8c\u8bc1\u7801\u7c7b\u578b\u4e0d\u5408\u6cd5");
                        this.captchaStorageApi.set("BUSINESS:CAPTCHA:TYPE:" + newCaptchaId, this.captchaStorageApi.get("BUSINESS:CAPTCHA:TYPE:" + checkCaptchaReq.getCaptchaId()));
                        this.captchaStorageApi.set(newCaptchaId, cacheCaptchaCode);
                        return new CheckCaptchaResp(newCaptchaId, true);
                    }
                    return new CheckCaptchaResp(captchaId, true);
                }
                throw new CaptchaIncorrectException();
            }
            throw new CaptchaTimeoutException();
        }
        throw new CaptchaNotFoundException();
    }
}

