package com.sinosoftgz.starter.captcha.storage.db.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosoftgz.starter.captcha.storage.db.entity.CommonCaptchaStorage;
import com.sinosoftgz.starter.captcha.storage.db.mapper.CommonCaptchaStorageMapper;
import com.sinosoftgz.starter.captcha.storage.db.service.ICommonCaptchaStorageService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

import java.util.Objects;


/**
 * <p>
 * 验证码存储表 服务实现类
 * </p>
 *
 * @author Roney
 * @since 2022-05-07
 */
@Service
public class CommonCaptchaStorageServiceImpl extends ServiceImpl<CommonCaptchaStorageMapper, CommonCaptchaStorage> implements ICommonCaptchaStorageService {

    @Override
    public void set(String key, String value, long expiresInSeconds) {
        DateTime now = new DateTime();
        now = now.plusMillis(new Long(expiresInSeconds).intValue());
        CommonCaptchaStorage commonCaptchaStorage = new CommonCaptchaStorage();
        commonCaptchaStorage.setId(key);
        commonCaptchaStorage.setCaptchaCode(value);
        commonCaptchaStorage.setCaptchaExpirationDate(now.toDate());
        this.save(commonCaptchaStorage);
    }

    @Override
    public boolean hasKey(String key) {
        CommonCaptchaStorage commonCaptchaStorage = query(key);
        if (!Objects.isNull(commonCaptchaStorage)) {
            return true;
        }
        return false;
    }


    @Override
    public void delete(String key) {
        this.removeById(key);
    }

    @Override
    public Object get(String key) {
        CommonCaptchaStorage commonCaptchaStorage = this.query(key);
        if (!Objects.isNull(commonCaptchaStorage)) {
            return commonCaptchaStorage.getCaptchaCode();
        }
        return null;
    }

    private CommonCaptchaStorage query(String key) {
        QueryWrapper<CommonCaptchaStorage> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(CommonCaptchaStorage.ID, key);
        queryWrapper.ge(CommonCaptchaStorage.CAPTCHA_EXPIRATION_DATE, new DateTime().toDate());
        CommonCaptchaStorage commonCaptchaStorage = this.getOne(queryWrapper);
        return commonCaptchaStorage;
    }
}
