/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.storage.db.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.sinosoftgz.starter.captcha.storage.db.entity.CommonCaptchaStorage;
import com.sinosoftgz.starter.captcha.storage.db.mapper.CommonCaptchaStorageMapper;
import com.sinosoftgz.starter.captcha.storage.db.service.ICommonCaptchaStorageService;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class CommonCaptchaStorageServiceImpl
extends ServiceImpl<CommonCaptchaStorageMapper, CommonCaptchaStorage>
implements ICommonCaptchaStorageService {
    @Override
    public void set(String key, String value, long expiresInSeconds) {
        DateTime now = new DateTime();
        now = now.plusMillis(new Long(expiresInSeconds).intValue());
        CommonCaptchaStorage commonCaptchaStorage = new CommonCaptchaStorage();
        commonCaptchaStorage.setId(key);
        commonCaptchaStorage.setCaptchaCode(value);
        commonCaptchaStorage.setCaptchaExpirationDate(now.toDate());
        this.save((Object)commonCaptchaStorage);
    }

    @Override
    public boolean hasKey(String key) {
        CommonCaptchaStorage commonCaptchaStorage = this.query(key);
        return !Objects.isNull((Object)commonCaptchaStorage);
    }

    @Override
    public void delete(String key) {
        this.removeById((Serializable)((Object)key));
    }

    @Override
    public Object get(String key) {
        CommonCaptchaStorage commonCaptchaStorage = this.query(key);
        if (!Objects.isNull((Object)commonCaptchaStorage)) {
            return commonCaptchaStorage.getCaptchaCode();
        }
        return null;
    }

    private CommonCaptchaStorage query(String key) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)key);
        queryWrapper.ge((Object)"captcha_expiration_date", (Object)new DateTime().toDate());
        CommonCaptchaStorage commonCaptchaStorage = (CommonCaptchaStorage)((Object)this.getOne((Wrapper)queryWrapper));
        return commonCaptchaStorage;
    }
}

