package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;

import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.wf.captcha.ArithmeticCaptcha;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author: Roney
 * @date: 2021-12-07 12:00
 * @description: ArithmeticCaptchaHandler
 */
@Component
@CaptchaHandlerType(BusinessCaptchaType.EASY_CAPTCHA_ARITHMETIC)
@Slf4j
public class ArithmeticEasyCaptchaHandler extends DefaultEasyCaptchaHandler {


    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        ArithmeticCaptcha captcha = getArithmeticCaptcha(getCaptchaReq);

        return generatorCaptchaResp(captcha);
    }

    /**
     * 获取验证码实现类
     *
     * @return
     */
    public ArithmeticCaptcha getArithmeticCaptcha(GetCaptchaReq getCaptchaReq) {
        /**
         * 宽度 默认130
         */
        Integer width = easyCaptchaProperties.getArithmetic().getWidth();
        /**
         * 高度 默认48
         */
        Integer height = easyCaptchaProperties.getArithmetic().getHeight();
        /**
         * 长度 默认3
         */
        Integer length = easyCaptchaProperties.getArithmetic().getLength();
        if (!Objects.isNull(getCaptchaReq) && !Objects.isNull(getCaptchaReq.getWidth()) && !Objects.isNull(getCaptchaReq.getHeight()) && !Objects.isNull(getCaptchaReq.getLength())) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        ArithmeticCaptcha captcha = new ArithmeticCaptcha(width, height, length);
        return captcha;
    }
}
