package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;

import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.wf.captcha.ChineseCaptcha;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author: Roney
 * @date: 2021-12-07 11:49
 * @description: ChineseCaptchaHandler
 */
@Component
@CaptchaHandlerType(BusinessCaptchaType.EASY_CAPTCHA_CHINESE)
@Slf4j
public class ChineseEasyCaptchaHandler extends DefaultEasyCaptchaHandler {


    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        ChineseCaptcha captcha = getChineseCaptcha(getCaptchaReq);

        return generatorCaptchaResp(captcha);
    }

    /**
     * 获取验证码实现类
     *
     * @return
     */
    public ChineseCaptcha getChineseCaptcha(GetCaptchaReq getCaptchaReq) {
        /**
         * 宽度 默认130
         */
        Integer width = easyCaptchaProperties.getChinese().getWidth();
        /**
         * 高度 默认48
         */
        Integer height = easyCaptchaProperties.getChinese().getHeight();
        /**
         * 长度 默认5
         */
        Integer length = easyCaptchaProperties.getChinese().getLength();
        if (!Objects.isNull(getCaptchaReq) && !Objects.isNull(getCaptchaReq.getWidth()) && !Objects.isNull(getCaptchaReq.getHeight()) && !Objects.isNull(getCaptchaReq.getLength())) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        ChineseCaptcha captcha = new ChineseCaptcha(width, height, length);
        return captcha;
    }
}
