package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.sinosoftgz.starter.easy.captcha.properties.EasyCaptchaProperties;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author: Roney
 * @date: 2021-12-07 11:46
 * @description: DefaultCaptchaHandler
 */
@Component
@CaptchaHandlerType(BusinessCaptchaType.EASY_CAPTCHA_DEFAULT)
@Slf4j
public class DefaultEasyCaptchaHandler extends DefaultCaptchaHandler {

    @Resource
    public EasyCaptchaProperties easyCaptchaProperties;


    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        SpecCaptcha captcha = getSpecCaptcha(getCaptchaReq);

        return generatorCaptchaResp(captcha);
    }

    /**
     * 获取验证码实现类
     *
     * @return
     */
    public SpecCaptcha getSpecCaptcha(GetCaptchaReq getCaptchaReq) {

        /**
         * 宽度 默认130
         */
        Integer width = easyCaptchaProperties.getSpec().getWidth();
        /**
         * 高度 默认48
         */
        Integer height = easyCaptchaProperties.getSpec().getHeight();
        /**
         * 长度 默认5
         */
        Integer length = easyCaptchaProperties.getSpec().getLength();
        if (!Objects.isNull(getCaptchaReq) && !Objects.isNull(getCaptchaReq.getWidth()) && !Objects.isNull(getCaptchaReq.getHeight()) && !Objects.isNull(getCaptchaReq.getLength())) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        SpecCaptcha captcha = new SpecCaptcha(width, height, length);
        captcha.setCharType(Captcha.TYPE_DEFAULT);
        return captcha;
    }

    /**
     * 组装返回结果，并设置缓存
     *
     * @param captcha
     * @return
     */
    public GetCaptchaResp generatorCaptchaResp(Captcha captcha) {
        /**
         * 验证码的值
         */
        String verCode = captcha.text().toLowerCase();
        /**
         * 验证码id
         */
        String captchaId = getUuid();

        /**
         * 原生图片base64
         */
        String originalImageBase64 = captcha.toBase64("");

        /**
         * base64的头部data:image/png;base64
         */
        String imageBase64 = captcha.toBase64();
        /**
         * 生成随机ID做为key，验证码的值做为value，放入缓存中
         */
        captchaStorageApi.set(captchaId, verCode);
        return new GetCaptchaResp(captchaId, originalImageBase64, imageBase64);
    }


}
