package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;

import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.base.Captcha;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author: Roney
 * @date: 2021-12-07 11:46
 * @description: GifDefaultCaptchaHandler
 */
@Component
@CaptchaHandlerType(BusinessCaptchaType.EASY_CAPTCHA_GIF_DEFAULT)
@Slf4j
public class GifDefaultEasyCaptchaHandler extends DefaultEasyCaptchaHandler {


    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        GifCaptcha captcha = getGifCaptcha(getCaptchaReq);
        return generatorCaptchaResp(captcha);
    }

    /**
     * 获取验证码实现类
     *
     * @return
     */
    public GifCaptcha getGifCaptcha(GetCaptchaReq getCaptchaReq) {
        /**
         * 宽度 默认130
         */
        Integer width = easyCaptchaProperties.getSpec().getWidth();
        /**
         * 高度 默认48
         */
        Integer height = easyCaptchaProperties.getSpec().getHeight();
        /**
         * 长度 默认5
         */
        Integer length = easyCaptchaProperties.getSpec().getLength();
        if (!Objects.isNull(getCaptchaReq) && !Objects.isNull(getCaptchaReq.getWidth()) && !Objects.isNull(getCaptchaReq.getHeight()) && !Objects.isNull(getCaptchaReq.getLength())) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        GifCaptcha captcha = new GifCaptcha(width, height, length);
        captcha.setCharType(Captcha.TYPE_DEFAULT);
        return captcha;
    }


}
