package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: Roney
 * @date: 2021-12-07 11:49
 * @description: OnlyNumberCaptchaHandler
 */
@Component
@CaptchaHandlerType(BusinessCaptchaType.EASY_CAPTCHA_ONLY_NUMBER)
@Slf4j
public class OnlyNumberEasyCaptchaHandler extends DefaultEasyCaptchaHandler {

    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        SpecCaptcha captcha = getSpecCaptcha(getCaptchaReq);
        captcha.setCharType(Captcha.TYPE_ONLY_NUMBER);
        return generatorCaptchaResp(captcha);
    }
}
