package com.sinosoftgz.starter.easy.captcha.config;

import com.sinosoftgz.starter.easy.captcha.properties.EasyCaptchaProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;


/**
 * @author: Roney
 * @date: 2021-12-02 11:48
 * @description: EasyCaptchaConfiguration
 */

@Configuration
@EnableConfigurationProperties(EasyCaptchaProperties.class)
@ConditionalOnProperty(prefix = EasyCaptchaProperties.EASY_CAPTCHA_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class EasyCaptchaConfiguration {

    private EasyCaptchaProperties easyCaptchaProperties;

    public EasyCaptchaConfiguration(final EasyCaptchaProperties easyCaptchaProperties) {
        this.easyCaptchaProperties = easyCaptchaProperties;
    }


}
