package com.sinosoftgz.starter.easy.captcha.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author: Roney
 * @date: 2021-12-02 11:53
 * @description: EasyCaptchaProperties
 */
@ConfigurationProperties(prefix = EasyCaptchaProperties.EASY_CAPTCHA_PREFIX)
@Data
public class EasyCaptchaProperties {

    public static final String EASY_CAPTCHA_PREFIX = "captcha.easy.captcha";

    /**
     * 宽度 默认130
     */
    private static final Integer width = 130;
    /**
     * 高度 默认48
     */
    private static final Integer height = 48;

    /**
     * 长度 默认5
     */
    private static final Integer length = 5;

    /**
     * 是否开启
     * 默认开启
     */
    private boolean enabled = true;


    /**
     * 普通字符
     */
    @NestedConfigurationProperty
    private Spec spec = new Spec();

    /**
     * 中文
     */
    @NestedConfigurationProperty
    private Chinese chinese = new Chinese();

    /**
     * 算术运算符
     */
    @NestedConfigurationProperty
    private Arithmetic arithmetic = new Arithmetic();

    @Data
    public static class Spec {

        /**
         * 宽度 默认130
         */
        private Integer width = EasyCaptchaProperties.width;
        /**
         * 高度 默认48
         */
        private Integer height = EasyCaptchaProperties.height;
        /**
         * 长度 默认5
         */
        private Integer length = EasyCaptchaProperties.length;

    }

    @Data
    public static class Chinese {

        /**
         * 宽度 默认130
         */
        private Integer width = EasyCaptchaProperties.width;
        /**
         * 高度 默认48
         */
        private Integer height = EasyCaptchaProperties.height;
        /**
         * 长度 默认5
         */
        private Integer length = EasyCaptchaProperties.length;

    }

    @Data
    public static class Arithmetic {

        /**
         * 宽度 默认130
         */
        private Integer width = EasyCaptchaProperties.width;
        /**
         * 高度 默认48
         */
        private Integer height = EasyCaptchaProperties.height;
        /**
         * 长度 默认3
         */
        private Integer length = EasyCaptchaProperties.length - 2;

    }


}
