/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.handler.biz.DefaultEasyCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.base.Captcha;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@CaptchaHandlerType(value=BusinessCaptchaType.EASY_CAPTCHA_ARITHMETIC)
public class ArithmeticEasyCaptchaHandler
extends DefaultEasyCaptchaHandler {
    private static final Logger log = LoggerFactory.getLogger(ArithmeticEasyCaptchaHandler.class);

    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        ArithmeticCaptcha captcha = this.getArithmeticCaptcha(getCaptchaReq);
        return this.generatorCaptchaResp((Captcha)captcha);
    }

    public ArithmeticCaptcha getArithmeticCaptcha(GetCaptchaReq getCaptchaReq) {
        Integer width = this.easyCaptchaProperties.getArithmetic().getWidth();
        Integer height = this.easyCaptchaProperties.getArithmetic().getHeight();
        Integer length = this.easyCaptchaProperties.getArithmetic().getLength();
        if (!(Objects.isNull(getCaptchaReq) || Objects.isNull(getCaptchaReq.getWidth()) || Objects.isNull(getCaptchaReq.getHeight()) || Objects.isNull(getCaptchaReq.getLength()))) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        ArithmeticCaptcha captcha = new ArithmeticCaptcha(width.intValue(), height.intValue(), length.intValue());
        return captcha;
    }
}

