/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.handler.biz.DefaultCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.sinosoftgz.starter.easy.captcha.properties.EasyCaptchaProperties;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@CaptchaHandlerType(value=BusinessCaptchaType.EASY_CAPTCHA_DEFAULT)
public class DefaultEasyCaptchaHandler
extends DefaultCaptchaHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultEasyCaptchaHandler.class);
    @Resource
    public EasyCaptchaProperties easyCaptchaProperties;

    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        SpecCaptcha captcha = this.getSpecCaptcha(getCaptchaReq);
        return this.generatorCaptchaResp((Captcha)captcha);
    }

    public SpecCaptcha getSpecCaptcha(GetCaptchaReq getCaptchaReq) {
        Integer width = this.easyCaptchaProperties.getSpec().getWidth();
        Integer height = this.easyCaptchaProperties.getSpec().getHeight();
        Integer length = this.easyCaptchaProperties.getSpec().getLength();
        if (!(Objects.isNull(getCaptchaReq) || Objects.isNull(getCaptchaReq.getWidth()) || Objects.isNull(getCaptchaReq.getHeight()) || Objects.isNull(getCaptchaReq.getLength()))) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        SpecCaptcha captcha = new SpecCaptcha(width.intValue(), height.intValue(), length.intValue());
        captcha.setCharType(1);
        return captcha;
    }

    public GetCaptchaResp generatorCaptchaResp(Captcha captcha) {
        String verCode = captcha.text().toLowerCase();
        String captchaId = this.getUuid();
        String originalImageBase64 = captcha.toBase64("");
        String imageBase64 = captcha.toBase64();
        this.captchaStorageApi.set(captchaId, verCode);
        return new GetCaptchaResp(captchaId, originalImageBase64, imageBase64);
    }
}

