/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.handler.biz.ChineseEasyCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.base.Captcha;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@CaptchaHandlerType(value=BusinessCaptchaType.EASY_CAPTCHA_GIF_CHINESE)
public class GifChineseEasyCaptchaHandler
extends ChineseEasyCaptchaHandler {
    private static final Logger log = LoggerFactory.getLogger(GifChineseEasyCaptchaHandler.class);

    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        ChineseGifCaptcha captcha = this.getChineseGifCaptcha(getCaptchaReq);
        return this.generatorCaptchaResp((Captcha)captcha);
    }

    public ChineseGifCaptcha getChineseGifCaptcha(GetCaptchaReq getCaptchaReq) {
        Integer width = this.easyCaptchaProperties.getChinese().getWidth();
        Integer height = this.easyCaptchaProperties.getChinese().getHeight();
        Integer length = this.easyCaptchaProperties.getChinese().getLength();
        if (!(Objects.isNull(getCaptchaReq) || Objects.isNull(getCaptchaReq.getWidth()) || Objects.isNull(getCaptchaReq.getHeight()) || Objects.isNull(getCaptchaReq.getLength()))) {
            width = getCaptchaReq.getWidth();
            height = getCaptchaReq.getHeight();
            length = getCaptchaReq.getLength();
        }
        ChineseGifCaptcha captcha = new ChineseGifCaptcha(width.intValue(), height.intValue(), length.intValue());
        return captcha;
    }
}

