/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.kaptcha;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.sinosoftgz.starter.kaptcha.Kaptcha;
import com.sinosoftgz.starter.kaptcha.exception.KaptchaIncorrectException;
import com.sinosoftgz.starter.kaptcha.exception.KaptchaNotFoundException;
import com.sinosoftgz.starter.kaptcha.exception.KaptchaRenderException;
import com.sinosoftgz.starter.kaptcha.exception.KaptchaTimeoutException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleKaptcha
implements Kaptcha {
    private static final Logger log = LoggerFactory.getLogger(GoogleKaptcha.class);
    private DefaultKaptcha kaptcha;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;

    public GoogleKaptcha(DefaultKaptcha kaptcha) {
        this.kaptcha = kaptcha;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String render() {
        this.response.setDateHeader("Expires", 0L);
        this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        this.response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setContentType("image/jpeg");
        String sessionCode = this.kaptcha.createText();
        try (ServletOutputStream out = this.response.getOutputStream();){
            this.request.getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)sessionCode);
            this.request.getSession().setAttribute("KAPTCHA_SESSION_DATE", (Object)System.currentTimeMillis());
            ImageIO.write((RenderedImage)this.kaptcha.createImage(sessionCode), "jpg", (OutputStream)out);
            String string = sessionCode;
            return string;
        }
        catch (IOException e) {
            throw new KaptchaRenderException(e);
        }
    }

    @Override
    public boolean validate(String code) {
        return this.validate(code, 900L);
    }

    @Override
    public boolean validate(@NonNull String code, long second) {
        String sessionCode;
        if (code == null) {
            throw new NullPointerException("code");
        }
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null && (sessionCode = (String)httpSession.getAttribute("KAPTCHA_SESSION_KEY")) != null) {
            if (sessionCode.equalsIgnoreCase(code)) {
                long sessionTime = (Long)httpSession.getAttribute("KAPTCHA_SESSION_DATE");
                long duration = (System.currentTimeMillis() - sessionTime) / 1000L;
                if (duration < second) {
                    httpSession.removeAttribute("KAPTCHA_SESSION_KEY");
                    httpSession.removeAttribute("KAPTCHA_SESSION_DATE");
                    return true;
                }
                throw new KaptchaTimeoutException();
            }
            throw new KaptchaIncorrectException();
        }
        throw new KaptchaNotFoundException();
    }
}

