package com.sinosoftgz.starter.captcha.core.handler.biz;

import cn.hutool.core.util.IdUtil;
import com.baomidou.kaptcha.exception.KaptchaRenderException;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaRenderException;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;

/**
 * 谷歌验证码默认实现
 *
 * @author: Roney
 * @createTime: 2022/06/20 15:31
 * @description: 谷歌验证码默认实现
 */
@Slf4j
public class DefaultKaptchaHandler extends DefaultCaptchaHandler {

    private DefaultKaptcha defaultKaptcha;

    public DefaultKaptchaHandler(DefaultKaptcha defaultKaptcha) {
        this.defaultKaptcha = defaultKaptcha;
    }

    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        String sessionCode = defaultKaptcha.createText();
        BufferedImage image = defaultKaptcha.createImage(sessionCode);

        return generatorCaptchaResp(sessionCode, image);
    }

    /**
     * 验证码输出,
     *
     * @param image BufferedImage
     * @param out   输出流
     * @return 是否成功
     */
    public boolean out(BufferedImage image, OutputStream out) {
        try {
            return ImageIO.write(image, "jpg", out);
        } catch (IOException e) {
            log.error("渲染验证码异常", e);
            throw new CaptchaRenderException();
        }
    }

    /**
     * 输出base64编码
     *
     * @return base64编码字符串
     */
    public String toBase64(BufferedImage image) {
        return toBase64("data:image/png;base64,", image);
    }

    /**
     * 输出base64编码
     *
     * @param type 编码头
     * @return base64编码字符串
     */
    public String toBase64(String type, BufferedImage image) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        out(image, outputStream);
        return type + Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }


    public GetCaptchaResp generatorCaptchaResp(String sessionCode, BufferedImage image) {
        /**
         * 验证码的值
         */
        String verCode = sessionCode.toLowerCase();

        /**
         *
         * 验证码id
         */
        String captchaId = getUuid();

        /**
         * 原生图片base64
         */
        String originalImageBase64 = toBase64("", image);

        /**
         * base64的头部data:image/png;base64
         */
        String imageBase64 = toBase64(image);
        captchaStorageApi.set(captchaId, verCode);
        return new GetCaptchaResp(captchaId, originalImageBase64, imageBase64);
    }
}
