package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.sinosoftgz.starter.captcha.core.enums.BusinessCaptchaType;
import com.sinosoftgz.starter.captcha.core.handler.annotation.CaptchaHandlerType;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.awt.image.BufferedImage;

/**
 * 谷歌数字运算符验证码实现
 *
 * @author: Roney
 * @createTime: 2022/06/20 15:42
 * @description: 谷歌数字运算符验证码实现
 */
@Component
@CaptchaHandlerType(BusinessCaptchaType.KAPTCHA_MATH_EXPRESSION)
@Slf4j
public class MathExpressionKaptchaHandler extends DefaultKaptchaHandler {
    private DefaultKaptcha captchaMathExpression;


    public MathExpressionKaptchaHandler(DefaultKaptcha captchaMathExpression) {
        super(captchaMathExpression);

        this.captchaMathExpression = captchaMathExpression;

    }

    /**
     * 获取验证码
     *
     * @param getCaptchaReq 获取验证码请求参数
     * @return
     */
    @Override
    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        String capStr = null;
        String code = null;
        String sessionCode = captchaMathExpression.createText();
        capStr = sessionCode.substring(0, sessionCode.lastIndexOf("@"));
        code = sessionCode.substring(sessionCode.lastIndexOf("@") + 1);

        BufferedImage image = captchaMathExpression.createImage(capStr);

        return generatorCaptchaResp(code, image);
    }
}
