//package com.sinosoftgz.starter.kaptcha.handler.impl;
//
//import cn.hutool.core.util.IdUtil;
//import com.sinosoftgz.starter.kaptcha.handler.CaptchaHandler;
//import com.sinosoftgz.starter.kaptcha.request.CheckCaptchaReq;
//import com.sinosoftgz.starter.kaptcha.request.GetCaptchaReq;
//import com.sinosoftgz.starter.kaptcha.response.CheckCaptchaResp;
//import com.sinosoftgz.starter.kaptcha.response.GetCaptchaResp;
//import com.sinosoftgz.starter.kaptcha.storage.CaptchaStorage;
//import lombok.NonNull;
//import lombok.extern.slf4j.Slf4j;
//
//
//import javax.annotation.Resource;
//
//import java.awt.image.BufferedImage;
//import java.io.ByteArrayOutputStream;
//import java.io.OutputStream;
//import java.util.Base64;
//
//
///**
// * @author: Roney
// * @date: 2021-12-01 11:55
// * @description: AbstractKaptcha
// */
//
//@Slf4j
//public abstract class AbstractKaptcha implements CaptchaHandler {
//
//    @Resource
//    public CaptchaStorage captchaStorage;
//
//    @Override
//    public abstract String render();
//
//
//    @Override
//    public boolean validate(String code) {
//        return validate(code, 900);
//    }
//
//    @Override
//    public abstract boolean validate(@NonNull String code, long second);
//
//    /**
//     * 获取验证码
//     *
//     * @param getCaptchaReq 获取验证码请求参数
//     * @return
//     */
//    @Override
//    public abstract GetCaptchaResp get(GetCaptchaReq getCaptchaReq);
//
//    /**
//     * 校验验证码
//     *
//     * @param checkCaptchaReq
//     * @return
//     */
//    @Override
//    public abstract CheckCaptchaResp check(CheckCaptchaReq checkCaptchaReq);
//
//
//    /**
//     * 验证码输出,抽象方法，由子类实现
//     *
//     * @param image BufferedImage
//     * @param out   输出流
//     * @return 是否成功
//     */
//    public abstract boolean out(BufferedImage image, OutputStream out);
//
//    /**
//     * 输出base64编码
//     *
//     * @return base64编码字符串
//     */
//    public String toBase64(BufferedImage image) {
//        return toBase64("data:image/png;base64,", image);
//    }
//
//    /**
//     * 输出base64编码
//     *
//     * @param type 编码头
//     * @return base64编码字符串
//     */
//    public String toBase64(String type, BufferedImage image) {
//        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
//        out(image, outputStream);
//        return type + Base64.getEncoder().encodeToString(outputStream.toByteArray());
//    }
//
//    /**
//     * 生成UUID
//     *
//     * @return
//     */
//    public String getUuid() {
//        //生成的是不带-的字符串，类似于：b17f24ff026d40949c85a24f4f375d42
//        String simpleUUID = IdUtil.simpleUUID();
//        return simpleUUID;
//    }
//
//    public GetCaptchaResp generatorCaptchaResp(String sessionCode, BufferedImage image) {
//        /**
//         * 验证码的值
//         */
//        String verCode = sessionCode.toLowerCase();
//
//        /**
//         *
//         * 验证码id
//         */
//        String captchaId = getUuid();
//
//        /**
//         * 原生图片base64
//         */
//        String originalImageBase64 = toBase64("", image);
//
//        /**
//         * base64的头部data:image/png;base64
//         */
//        String imageBase64 = toBase64(image);
//        captchaStorage.set(captchaId, verCode);
//        return new GetCaptchaResp(captchaId, originalImageBase64, imageBase64);
//    }
//
//}
