///**
// * Copyright © 2018 TaoYu (tracy5546@gmail.com)
// * <p>
// * Licensed under the Apache License, Version 2.0 (the "License");
// * you may not use this file except in compliance with the License.
// * You may obtain a copy of the License at
// * <p>
// * http://www.apache.org/licenses/LICENSE-2.0
// * <p>
// * Unless required by applicable law or agreed to in writing, software
// * distributed under the License is distributed on an "AS IS" BASIS,
// * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// * See the License for the specific language governing permissions and
// * limitations under the License.
// */
//package com.sinosoftgz.starter.kaptcha.handler.impl;
//
//import com.baomidou.kaptcha.exception.KaptchaRenderException;
//import com.google.code.kaptcha.impl.DefaultKaptcha;
//
//import java.awt.image.BufferedImage;
//import java.io.ByteArrayOutputStream;
//import java.io.IOException;
//
//import com.sinosoftgz.starter.kaptcha.request.GetCaptchaReq;
//import com.sinosoftgz.starter.kaptcha.response.GetCaptchaResp;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.stereotype.Component;
//
//import javax.imageio.ImageIO;
//import javax.servlet.ServletOutputStream;
//
//import static com.google.code.kaptcha.Constants.KAPTCHA_SESSION_DATE;
//import static com.google.code.kaptcha.Constants.KAPTCHA_SESSION_KEY;
//
///**
// * 谷歌默认验证码组件
// *
// * @author TaoYu
// */
//@Slf4j
//@Component
//public class CharKaptcha extends com.sinosoftgz.starter.kaptcha.handler.impl.DefaultKaptcha {
//
//    private DefaultKaptcha defaultKaptcha;
//
//    public CharKaptcha(DefaultKaptcha defaultKaptcha) {
//        this.defaultKaptcha = defaultKaptcha;
//    }
//
//    @Override
//    public String render() {
//        generatorResponse();
//        String sessionCode = defaultKaptcha.createText();
//        try (ServletOutputStream out = response.getOutputStream()) {
//            request.getSession().setAttribute(KAPTCHA_SESSION_KEY, sessionCode);
//            request.getSession().setAttribute(KAPTCHA_SESSION_DATE, System.currentTimeMillis());
//            ImageIO.write(defaultKaptcha.createImage(sessionCode), "jpg", out);
//            return sessionCode;
//        } catch (IOException e) {
//            throw new KaptchaRenderException(e);
//        }
//    }
//
//    /**
//     * 获取验证码
//     *
//     * @param getCaptchaReq 获取验证码请求参数
//     * @return
//     */
//    @Override
//    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
//        String sessionCode = defaultKaptcha.createText();
//        BufferedImage image = defaultKaptcha.createImage(sessionCode);
//
//        return generatorCaptchaResp(sessionCode, image);
//    }
//
//
//}
//
