//package com.sinosoftgz.starter.kaptcha.handler.impl;
//
//import com.baomidou.kaptcha.exception.KaptchaIncorrectException;
//import com.baomidou.kaptcha.exception.KaptchaNotFoundException;
//import com.baomidou.kaptcha.exception.KaptchaRenderException;
//import com.baomidou.kaptcha.exception.KaptchaTimeoutException;
//import com.sinosoftgz.starter.kaptcha.request.CheckCaptchaReq;
//import com.sinosoftgz.starter.kaptcha.request.GetCaptchaReq;
//import com.sinosoftgz.starter.kaptcha.response.CheckCaptchaResp;
//import com.sinosoftgz.starter.kaptcha.response.GetCaptchaResp;
//import lombok.NonNull;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.HttpHeaders;
//import org.springframework.util.StringUtils;
//
//import javax.imageio.ImageIO;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import javax.servlet.http.HttpSession;
//import java.awt.image.BufferedImage;
//import java.io.IOException;
//import java.io.OutputStream;
//import java.util.Objects;
//
//import static com.google.code.kaptcha.Constants.KAPTCHA_SESSION_DATE;
//import static com.google.code.kaptcha.Constants.KAPTCHA_SESSION_KEY;
//
///**
// * @author: Roney
// * @date: 2021-12-09 15:00
// * @description: DefaultKaptcha
// */
//public abstract class DefaultKaptcha extends AbstractKaptcha {
//
//    @Autowired
//    public HttpServletRequest request;
//
//    @Autowired
//    public HttpServletResponse response;
//
//
//    @Override
//    public abstract String render();
//
//
//    @Override
//    public boolean validate(@NonNull String code, long second) {
//        HttpSession httpSession = request.getSession(false);
//        String sessionCode;
//        if (httpSession != null && (sessionCode = (String) httpSession.getAttribute(KAPTCHA_SESSION_KEY)) != null) {
//            if (sessionCode.equalsIgnoreCase(code)) {
//                long sessionTime = (long) httpSession.getAttribute(KAPTCHA_SESSION_DATE);
//                long duration = (System.currentTimeMillis() - sessionTime) / 1000;
//                if (duration < second) {
//                    httpSession.removeAttribute(KAPTCHA_SESSION_KEY);
//                    httpSession.removeAttribute(KAPTCHA_SESSION_DATE);
//                    return true;
//                } else {
//                    throw new KaptchaTimeoutException();
//                }
//            } else {
//                throw new KaptchaIncorrectException();
//            }
//        } else {
//            throw new KaptchaNotFoundException();
//        }
//    }
//
//    /**
//     * 获取验证码
//     *
//     * @param getCaptchaReq 获取验证码请求参数
//     * @return
//     */
//    @Override
//    public abstract GetCaptchaResp get(GetCaptchaReq getCaptchaReq);
//
//    /**
//     * 校验验证码
//     *
//     * @param checkCaptchaReq
//     * @return
//     */
//    @Override
//    public CheckCaptchaResp check(CheckCaptchaReq checkCaptchaReq) {
//        if (!Objects.isNull(checkCaptchaReq) && StringUtils.hasLength(checkCaptchaReq.getCaptchaId()) && StringUtils.hasLength(checkCaptchaReq.getCaptchaCode())) {
//            String captchaId = checkCaptchaReq.getCaptchaId();
//            if (captchaStorage.exists(captchaId)) {
//                String captchaCode = checkCaptchaReq.getCaptchaCode();
//                String cacheCaptchaCode = captchaStorage.get(captchaId);
//                if (captchaCode.equalsIgnoreCase(cacheCaptchaCode)) {
//                    /**
//                     * 校验通过后，需要删除数据
//                     */
//                    captchaStorage.delete(captchaId);
//                    /**
//                     * 是否需要二次校验，如果需要，重新生成新的key，value保持不变，进行缓存
//                     */
//                    if (checkCaptchaReq.isCheckAgain()) {
//                        String newCaptchaId = getUuid();
//                        captchaStorage.set(newCaptchaId, cacheCaptchaCode);
//                        return new CheckCaptchaResp(newCaptchaId, true);
//                    }
//                    return new CheckCaptchaResp(captchaId, true);
//                } else {
//                    throw new KaptchaIncorrectException();
//                }
//            } else {
//                throw new KaptchaTimeoutException();
//            }
//        } else {
//            throw new KaptchaNotFoundException();
//        }
//    }
//
//
//    /**
//     * 验证码输出,抽象方法，由子类实现
//     *
//     * @param image BufferedImage
//     * @param out   输出流
//     * @return 是否成功
//     */
//    @Override
//    public boolean out(BufferedImage image, OutputStream out) {
//        try {
//            return ImageIO.write(image, "jpg", out);
//        } catch (IOException e) {
//            throw new KaptchaRenderException(e);
//        }
//    }
//
//    /**
//     * 生成HttpServletResponse
//     */
//    protected void generatorResponse() {
//        response.setDateHeader(HttpHeaders.EXPIRES, 0L);
//        response.setHeader(HttpHeaders.CACHE_CONTROL, "no-store, no-cache, must-revalidate");
//        response.addHeader(HttpHeaders.CACHE_CONTROL, "post-check=0, pre-check=0");
//        response.setHeader(HttpHeaders.PRAGMA, "no-cache");
//        response.setContentType("image/jpeg");
//    }
//}
