/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.captcha.core.handler.biz;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.sinosoftgz.starter.captcha.core.exception.CaptchaRenderException;
import com.sinosoftgz.starter.captcha.core.handler.biz.DefaultCaptchaHandler;
import com.sinosoftgz.starter.captcha.core.request.GetCaptchaReq;
import com.sinosoftgz.starter.captcha.core.response.GetCaptchaResp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKaptchaHandler
extends DefaultCaptchaHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultKaptchaHandler.class);
    private DefaultKaptcha defaultKaptcha;

    public DefaultKaptchaHandler(DefaultKaptcha defaultKaptcha) {
        this.defaultKaptcha = defaultKaptcha;
    }

    public GetCaptchaResp get(GetCaptchaReq getCaptchaReq) {
        String sessionCode = this.defaultKaptcha.createText();
        BufferedImage image = this.defaultKaptcha.createImage(sessionCode);
        return this.generatorCaptchaResp(sessionCode, image);
    }

    public boolean out(BufferedImage image, OutputStream out) {
        try {
            return ImageIO.write((RenderedImage)image, "jpg", out);
        }
        catch (IOException e) {
            log.error("\u6e32\u67d3\u9a8c\u8bc1\u7801\u5f02\u5e38", (Throwable)e);
            throw new CaptchaRenderException();
        }
    }

    public String toBase64(BufferedImage image) {
        return this.toBase64("data:image/png;base64,", image);
    }

    public String toBase64(String type, BufferedImage image) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.out(image, outputStream);
        return type + Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public GetCaptchaResp generatorCaptchaResp(String sessionCode, BufferedImage image) {
        String verCode = sessionCode.toLowerCase();
        String captchaId = this.getUuid();
        String originalImageBase64 = this.toBase64("", image);
        String imageBase64 = this.toBase64(image);
        this.captchaStorageApi.set(captchaId, verCode);
        return new GetCaptchaResp(captchaId, originalImageBase64, imageBase64);
    }
}

