/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.kaptcha.config;

import com.baomidou.kaptcha.spring.boot.KaptchaProperties;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"com.sinosoftgz.starter.kaptcha.**"})
@ConditionalOnClass(value={DefaultKaptcha.class})
@EnableConfigurationProperties(value={KaptchaProperties.class})
public class KaptchaConfiguration {
    private final KaptchaProperties properties;

    public KaptchaConfiguration(KaptchaProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"captchaMathExpression"})
    public DefaultKaptcha captchaMathExpression() {
        Properties prop = new Properties();
        prop.setProperty("kaptcha.image.width", String.valueOf(this.properties.getWidth()));
        prop.setProperty("kaptcha.image.height", String.valueOf(this.properties.getHeight()));
        KaptchaProperties.Content content = this.properties.getContent();
        prop.setProperty("kaptcha.textproducer.char.string", content.getSource());
        prop.setProperty("kaptcha.textproducer.char.length", String.valueOf(content.getLength()));
        prop.setProperty("kaptcha.textproducer.char.space", String.valueOf(content.getSpace()));
        KaptchaProperties.BackgroundColor backgroundColor = this.properties.getBackgroundColor();
        prop.setProperty("kaptcha.background.clear.from", backgroundColor.getFrom());
        prop.setProperty("kaptcha.background.clear.to", backgroundColor.getTo());
        KaptchaProperties.Border border = this.properties.getBorder();
        prop.setProperty("kaptcha.border", border.getEnabled() != false ? "yes" : "no");
        prop.setProperty("kaptcha.border.color", border.getColor());
        prop.setProperty("kaptcha.border.thickness", String.valueOf(border.getThickness()));
        KaptchaProperties.Font font = this.properties.getFont();
        prop.setProperty("kaptcha.textproducer.font.names", font.getName());
        prop.setProperty("kaptcha.textproducer.font.size", String.valueOf(font.getSize()));
        prop.setProperty("kaptcha.textproducer.font.color", font.getColor());
        prop.setProperty("kaptcha.textproducer.impl", "com.sinosoftgz.starter.kaptcha.text.impl.MathExpressionTextCreator");
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(new Config(prop));
        return defaultKaptcha;
    }
}

