package com.sinosoftgz.starter.captcha.storage.core.handler.biz;

import com.sinosoftgz.starter.captcha.storage.core.enums.CaptchaStorageType;
import com.sinosoftgz.starter.captcha.storage.core.handler.annotation.CaptchaStorageHandlerType;
import com.sinosoftgz.starter.captcha.storage.db.service.ICaptchaStorageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author: Roney
 * @date: 2022-06-10 15:42
 * @description: 验证码存储DB实现
 */
@Component
@CaptchaStorageHandlerType(CaptchaStorageType.db)
@Slf4j
public class DbCaptchaStorageHandler extends DefaultCaptchaStorageHandler {

    @Resource
    ICaptchaStorageService iCaptchaStorageService;

    @Override
    public void set(String key, String value, long expiresInSeconds) {
        checkKey(key);
        key = generatorKey(key);
        iCaptchaStorageService.set(key, value, expiresInSeconds);
    }

    @Override
    public boolean exists(String key) {
        checkKey(key);
        key = generatorKey(key);
        return iCaptchaStorageService.hasKey(key);
    }

    @Override
    public void delete(String key) {
        checkKey(key);
        key = generatorKey(key);
        iCaptchaStorageService.delete(key);
    }

    @Override
    public String get(String key) {
        checkKey(key);
        key = generatorKey(key);
        return (String) iCaptchaStorageService.get(key);
    }

    @Override
    public Long increment(String key, long val) {
        checkKey(key);
        Long ret = Long.valueOf((String) iCaptchaStorageService.get(key)) + val;
        iCaptchaStorageService.set(key, ret + "", 0);
        return ret;
    }
}
