package com.sinosoftgz.starter.captcha.storage.db.service;

import com.sinosoftgz.starter.captcha.storage.db.entity.CaptchaStorage;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 * 验证码存储表 服务类
 * </p>
 *
 * @author Roney
 * @since 2022-05-07
 */
public interface ICaptchaStorageService extends IService<CaptchaStorage> {

    /**
     * 设置存储的值
     *
     * @param key
     * @param value
     * @param expiresInSeconds 存储的是秒
     */
    void set(String key, String value, long expiresInSeconds);

    /**
     * 判断是否存在
     *
     * @param key
     * @return
     */
    boolean hasKey(String key);

    /**
     * 删除数据
     *
     * @param key
     */
    void delete(String key);

    /**
     * 获取值
     *
     * @param key
     * @return
     */
    Object get(String key);
}
