package com.sinosoftgz.starter.captcha.storage.db.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosoftgz.global.common.constants.CommonConstants;
import com.sinosoftgz.starter.captcha.storage.db.entity.CaptchaStorage;
import com.sinosoftgz.starter.captcha.storage.db.mapper.CaptchaStorageMapper;
import com.sinosoftgz.starter.captcha.storage.db.service.ICaptchaStorageService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Objects;


/**
 * <p>
 * 验证码存储表 服务实现类
 * </p>
 *
 * @author Roney
 * @since 2022-05-07
 */
@Service
public class CaptchaStorageServiceImpl extends ServiceImpl<CaptchaStorageMapper, CaptchaStorage> implements ICaptchaStorageService {

    /**
     * KEY的最大长度。数据库的最大长度
     */
    public static final Integer KEY_MAX_LENGTH = 512;

    @Override
    public void set(String key, String value, long expiresInSeconds) {
        checkKey(key);

        CaptchaStorage captchaStorage = this.query(key);
        if (Objects.isNull(captchaStorage)) {
            captchaStorage = new CaptchaStorage();
            captchaStorage.setCaptchaId(key);
        }
        DateTime now = new DateTime();
        now = now.plusMillis(new Long(expiresInSeconds).intValue());
        captchaStorage.setCaptchaCode(value);
        captchaStorage.setCaptchaExpirationDate(now.toDate());
        this.saveOrUpdate(captchaStorage);
    }

    @Override
    public boolean hasKey(String key) {
        checkKey(key);
        CaptchaStorage captchaStorage = query(key);
        if (!Objects.isNull(captchaStorage)) {
            return true;
        }
        return false;
    }


    @Override
    public void delete(String key) {
        checkKey(key);
        QueryWrapper<CaptchaStorage> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(CaptchaStorage.CAPTCHA_ID, key);
        queryWrapper.eq(CaptchaStorage.DELETE_FLAG, false);
        this.remove(queryWrapper);
    }

    @Override
    public Object get(String key) {
        checkKey(key);
        CaptchaStorage captchaStorage = this.query(key);
        if (!Objects.isNull(captchaStorage)) {
            return captchaStorage.getCaptchaCode();
        }
        return null;
    }


    private CaptchaStorage query(String key) {
        checkKey(key);
        QueryWrapper<CaptchaStorage> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(CaptchaStorage.CAPTCHA_ID, key);
        queryWrapper.eq(CaptchaStorage.DELETE_FLAG, false);
        queryWrapper.ge(CaptchaStorage.CAPTCHA_EXPIRATION_DATE, new DateTime().toDate());
        CaptchaStorage captchaStorage = this.getOne(queryWrapper);
        return captchaStorage;
    }

    /**
     * 校验参数是否合法
     *
     * @param key
     */
    private void checkKey(String key) {
        Assert.notNull(key, String.format(CommonConstants.MessageString.ASSERT_NOT_NULL_PROPERTY_NAME_MESSAGE, "key"));
        Assert.isTrue(key.length() <= KEY_MAX_LENGTH, "key最大值只能是:" + KEY_MAX_LENGTH);
    }
}
